/* eslint-disable max-len */
define([
    'underscore',
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/notification-selection/community-care-notification-settings-layout-view',
    'modules/community-care-request/new-appointment-request-question/notification-selection/request-details/request-details-phone-contact-section-view',
    'modules/new-appointment-request/views/common/email/section-view',
],
function(_, Backbone, Layout, CCNotificationSettingsLayout, PhoneContactSectionView, EmailPreferencesSectionView) {
    'use strict';
    describe('Notification/Request View Section', function() {
        var view;
        var model;
        var collection;
        var $view;
        var ccRequestModel;
        var layout;

        beforeEach(function () {
            model = new Backbone.Model({
                steps: [1, 2, 3, 4, 5, 6],
            });
            
            collection = new Backbone.Collection(
                [
                    {
                        name: 'ONE VAMC',
                        testItem: 'PVS-ALPHA-99',
                        facilityCode: '100',
                        supportsVAR: true,
                    },
                    {
                        name: 'TWO VAMC',
                        testItem: 'PVS-BETA-01',
                        facilityCode: '200',
                        supportsVAR: false,
                    },
                ]
            );

            layout = new Layout();

            layout.render();
            ccRequestModel = new Backbone.Model({
                service: 'service',
                travelBurden: true,
                unusualTravelBurden: false,
                typeOfCareId: 'CCUD',
                facility: 'Boston',
                zipCode: '02033',
                distanceWillingToTravel: '10',
                optionDate1: '11/08/2014',
                optionTime1: 'AM',
                optionDate2: 'No Date Selected',
                optionTime2: 'No Time Selected',
                optionDate3: 'No Date Selected',
                optionTime3: 'No Time Selected',
                phoneNumber: '703-234-5670',
                preferredProviders: {
                    provider1: '',
                },
                bestTimetoCall: [
                    'Afternoon',
                    'Evening',
                ],
                requestedPhoneCall: true,
                providerOption: 'Call before booking appointment',
                visitType: 'Office Visit',
                appointmentType: 'Audiology',
                reasonForVisit: 'Placeholder until the form has a reason for visit!',
                email: 'joe@joe.com',
                purposeOfVisit: 'routine-follow-up',
                providerId: '0',
                patientIdentifier: {
                    uniqueId: '1',
                    assigningAuthority: 'xxx',
                },
            });
            spyOn(CCNotificationSettingsLayout.prototype, 'disableContinueButton');
            spyOn(CCNotificationSettingsLayout.prototype, 'handleModelChange');
            spyOn(CCNotificationSettingsLayout.prototype, 'saveSettings');
            spyOn(CCNotificationSettingsLayout.prototype, 'saveCommunityCareRequests');
            spyOn(CCNotificationSettingsLayout.prototype, 'saveEmailPreferences');
            spyOn(EmailPreferencesSectionView.prototype, 'initialize').and.callFake(function() {
                this.collection = new Backbone.Collection();
                this.model = new Backbone.Model();
            });
            view = new CCNotificationSettingsLayout({
                model: model,
                patientEnrolledFacilities: collection,
            });
            view.emailPreferencesModel = new Backbone.Model({
                emailAddress: 'test123@joe.com',
            });

            layout.showChildView('fDNS   tent', view);
            $view = view.$el;
        });

        it('has regions to show form sections', function () {
            expect($view.has(view.regions.communityCareSettings).length).toEqual(1);
            expect($view.has(view.regions.emailPreferencesRegion).length).toEqual(1);
        });

        it('initiates the requests when submit request button is clicked', function() {
            $view.find('#submit-btn').click();
            expect(view.saveSettings).toHaveBeenCalled();
        });

        describe('should render the view', function() {
            it('should disable button when view is rednered and check if the model has changed', function() {
                jasmine.createSpy('show').and.callFake(function(_view) {
                    expect(_view.show).toHaveBeenCalled();
                    expect(_view.handleModelChange).toHaveBeenCalled();
                });
            });
        });

        describe('makes the requests for the Community Care Appointment', function() {
            it('should start with community care requests and then notification preferences', function() {
                jasmine.createSpy('saveSettings').and.callFake(function() {
                    expect(view.saveCommunityCareRequests).toHaveBeenCalledWith(ccRequestModel);
                    expect(view.saveEmailPreferences).toHaveBeenCalled();
                });
            });

            it('should set up for the requests model for community care ', function() {
                jasmine.createSpy('formatCommunityCareRequests').and.callFake(function(_ccRequestModel) {
                    expect(_ccRequestModel).toBe(_ccRequestModel);
                });
            });
        });

        describe('When creating the Community Care model', function() {
            it('will set distanceEligible to true when it is not set', function() {
                var formattedRequest;
                formattedRequest = view.formatCommunityCareRequests(ccRequestModel);
                expect(formattedRequest.get('distanceEligible')).toBe(true);
            });

            it('will set distanceEligible to true when set to yes', function() {
                var formattedRequest;
                ccRequestModel.set('distanceEligible', 'Yes');
                formattedRequest = view.formatCommunityCareRequests(ccRequestModel);
                expect(formattedRequest.get('distanceEligible')).toBe(true);
            });
        });
    });
});
